# This is the code for the ICLR 2024 paper "Towards Relaxing the Unbiasedness Condition of Doubly Robust Estimators for Debiased Recommendation".
## Environment Requirement

The code runs well at python 3.8.10. The required packages are as follows:

- pytorch == 1.13.0
- numpy == 1.23.3
- scipy == 1.9.1
- pandas == 1.5.0
- cppimport == 22.8.2

## Datasets

We use three public datasets (KuaiRec, Yahoo!R3 and Coat) for real-world experiments and ML-100K dataset (which named u.data in the uidr_synthetic/data folder) for semi-synthetic experiments. 

## For KuaiRec:
- user.txt: biased data collected by normal policy of recommendation platform. Each line is user ID, item ID, rating of the user to the item. 
- random.txt: unbiased data collected by policy where items are assigned to users randomly. Each line in the file is user ID, item ID, rating of the user to the item. 

## Run the Code for semi-synthetic experiments
First run the completion_uidr.ipynb to reconstruct the whole rating matrix, second run the convert_uidr.ipynb to obtain several widely-used prediction matrices. Finally run the synthetic_100k_uidr.ipynb file to obtain the results.

## Run the Code for real-world experiments

- For dataset KuaiRec:

```shell
python UIDR.py --dataset kuai
```

- For dataset Yahoo!R3:

```shell
python UIDR.py --dataset yahoo
```

- For dataset Coat:

```shell
python UIDR.py --dataset coat
```